/* Filename: "MSP430_SDQLIB.h" */

//******************************************************************************
// This file contains the functions necessary to implement SDQ communication.
// The code is written specifically for the MSP430 microcontroller using an I/O
// port pin. A 5k pullup resistor was used at 3.3V pullup voltage.
//******************************************************************************
#ifndef MSP430_SDQLIB_H
#define MSP430_SDQLIB_H

#include <msp430x23x0.h>                    // Target build for MSP430x23x0

#define P1_SDQ BIT1                         // P1.x used for the SDQ interface

#define SDQ_INPUT  (P1DIR&=~P1_SDQ)
#define SDQ_OUTPUT (P1DIR|=P1_SDQ)
#define SDQ_HIGH   (P1OUT|=P1_SDQ)
#define SDQ_LOW    (P1OUT&=~P1_SDQ)
#define SDQ_TOGGLE (P1OUT^=P1_SDQ)
#define SDQ_READ   (P1IN&P1_SDQ)

//------------------------------------------------------------------------------
// Define the SMCLK frequency
//------------------------------------------------------------------------------
#define SMCLKFREQHZ 8000000u                    // Timer clock frequency (Hz)
//------------------------------------------------------------------------------
// Define HDQ Protocol Related Timing Constants
//------------------------------------------------------------------------------
#define tUSEC       (1 * SMCLKFREQHZ / 1000000) // 1 usec worth of Timer_A tics
//------------------------------------------------------------------------------
// Exported functions (only for use with C)
//------------------------------------------------------------------------------
#ifdef __STDC__
void          SDQ_init(void);
void          SDQ_delayUSEC(unsigned int value);
void          SDQ_reset(void);
unsigned char SDQ_detect(void);
unsigned char SDQ_readBit(void);
unsigned char SDQ_readByte(void);
#endif
//------------------------------------------------------------------------------

#endif /* MSP430_SDQLIB_H */
